﻿#region PDFsharp - A .NET library for processing PDF
//
// Authors:
//   PDFsharp Team (mailto:PDFsharpSupport@pdfsharp.de)
//
// Copyright (c) 2005-2007 empira Software GmbH, Cologne (Germany)
//
// http://www.pdfsharp.com
// http://sourceforge.net/projects/pdfsharp
//
// Permission is hereby granted, free of charge, to any person obtaining a
// copy of this software and associated documentation files (the "Software"),
// to deal in the Software without restriction, including without limitation
// the rights to use, copy, modify, merge, publish, distribute, sublicense,
// and/or sell copies of the Software, and to permit persons to whom the
// Software is furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included
// in all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
// FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER 
// DEALINGS IN THE SOFTWARE.
#endregion

using System;
using System.Diagnostics;
using System.IO;
using PdfSharp.Pdf;
using PdfSharp.Drawing;
using PdfSharp.Drawing.Layout;

namespace Unicode
{
  /// <summary>
  /// This sample shows how to use Unicode text in PDFsharp.
  /// </summary>
  class Program
  {
    [STAThread]
    static void Main(string[] args)
    {
      // Create new document
      PdfDocument document = new PdfDocument();

      // Set unicode flag to true
      XPdfFontOptions options = new XPdfFontOptions(false, true);

      XFont font = new XFont("Times New Roman", 12, XFontStyle.Regular, options);

      // Draw text in different languages
      for (int idx = 0; idx < texts.Length; idx++)
      {
        PdfPage page = document.AddPage();
        XGraphics gfx = XGraphics.FromPdfPage(page);
        XTextFormatter tf = new XTextFormatter(gfx);
        tf.Alignment = XParagraphAlignment.Justify;

        tf.DrawString(texts[idx], font, XBrushes.Black,
          new XRect(100, 100, page.Width - 200, 600), XStringFormat.TopLeft);
      }

      string filename = "Unicode.pdf";
      // Save the document...
      document.Save(filename);
      // ...and start a viewer.
      Process.Start(filename);
    }

    static string[] texts = new string[]
    {
      // International version of the text in English
      "English\n" +
      "PDFsharp is a .NET library for creating and processing PDF documents 'on the fly'. " +
      "The library is completely written in C# and based exclusively on safe, managed code. " +
      "PDFsharp offers two powerful abstraction levels to create and process PDF documents.\n" +
      "For drawing text, graphics, and images there is a set of classes which are modeled similar to the classes " +
      "of the name space System.Drawing of the .NET framework. With these classes it is not only possible to create " +
      "the content of PDF pages in an easy way, but they can also be used to draw in a window or on a printer.\n" +
      "Additionally PDFsharp completely models the structure elements PDF is based on. With them existing PDF documents " +
      "can be modified, merged, or split with ease.\n" +
      "The source code of PDFsharp is Open Source under the MIT license (http://en.wikipedia.org/wiki/MIT_License). " +
      "Therefore it is possible to use PDFsharp without limitations in non open source or commercial projects/products.",

      // PDFsharp is 'Made in Germany'
      "German\n" +
      "PDFsharp ist eine .NET-Bibliothek zum Erzeugen und Verarbeiten von PDF-Dokumenten 'On the Fly'. " +
      "Die Bibliothek ist vollständig in C# geschrieben und basiert ausschließlich auf sicherem, verwaltetem Code. " +
      "PDFsharp bietet zwei leistungsstarke Abstraktionsebenen zur Erstellung und Verarbeitung von PDF-Dokumenten.\n" +
      "Zum Zeichnen von Text, Grafik und Bildern gibt es einen Satz von Klassen, die sehr stark an die Klassen " +
      "des Namensraums System.Drawing des .NET Frameworks angelehnt sind. Mit diesen Klassen ist es nicht " +
      "nur auf einfache Weise möglich, den Inhalt von PDF-Seiten zu gestalten, sondern sie können auch zum " +
      "Zeichnen in einem Fenster oder auf einem Drucker verwendet werden.\n" +
      "Zusätzlich modelliert PDFsharp vollständig die Stukturelemente, auf denen PDF basiert. Dadurch können existierende " +
      "PDF-Dokumente mit Leichtigkeit zerlegt, ergänzt oder umgebaut werden.\n" +
      "Der Quellcode von PDFsharp ist Open-Source unter der MIT-Lizenz (http://de.wikipedia.org/wiki/MIT-Lizenz). " +
      "Damit kann PDFsharp auch uneingeschränkt in Nicht-Open-Source- oder kommerziellen Projekten/Produkten eingesetzt werden.",

      // Greek version
      // The text was translated by Babel Fish. We here in Germany have no idea what it means.
      // If you are a native speaker please correct it and mail it to mailto:PDFsharpSupport@pdfsharp.de
      "Greek (Translated with Babel Fish)\n" +
      "Το PDFsharp είναι βιβλιοθήκη δικτύου α. για τη δημιουργία και την επεξεργασία των εγγράφων PDF 'σχετικά με τη μύγα'. Η βιβλιοθήκη γράφεται εντελώς γ # και βασίζεται αποκλειστικά εκτός από, διοικούμενος κώδικας. Το PDFsharp προσφέρει δύο ισχυρά επίπεδα αφαίρεσης για να δημιουργήσει και να επεξεργαστεί τα έγγραφα PDF. Για το κείμενο, τη γραφική παράσταση, και τις εικόνες σχεδίων υπάρχει ένα σύνολο κατηγοριών που διαμορφώνονται παρόμοιος με τις κατηγορίες του διαστημικού σχεδίου συστημάτων ονόματος του. πλαισίου δικτύου. Με αυτές τις κατηγορίες που είναι όχι μόνο δυνατό να δημιουργηθεί το περιεχόμενο των σελίδων PDF με έναν εύκολο τρόπο, αλλά αυτοί μπορεί επίσης να χρησιμοποιηθεί για να επισύρει την προσοχή σε ένα παράθυρο ή σε έναν εκτυπωτή. Επιπλέον PDFsharp διαμορφώνει εντελώς τα στοιχεία PDF δομών είναι βασισμένο. Με τους τα υπάρχοντα έγγραφα PDF μπορούν να τροποποιηθούν, συγχωνευμένος, ή να χωρίσουν με την ευκολία. Ο κώδικας πηγής PDFsharp είναι ανοικτή πηγή με άδεια MIT (http://en.wikipedia.org/wiki/MIT_License). Επομένως είναι δυνατό να χρησιμοποιηθεί PDFsharp χωρίς προβλήματα στη μη ανοικτή πηγή ή τα εμπορικά προγράμματα/τα προϊόντα.",

      // Russian version
      // The text was translated by Babel Fish. We here in Germany have no idea what it means.
      // If you are a native speaker please correct it and mail it to mailto:PDFsharpSupport@pdfsharp.de
      "Russia (Translated with Babel Fish)\n" +
      "PDFsharp будет архивом NET для создавать и обрабатывать документы pdf ' на мухе '. Архив вполне написан в ч # и основан исключительн на за исключением, управляемое Кодий. PDFsharp предлагает 2 мощных уровня абстракции для того чтобы создать и обработать документы pdf. Для рисуя текста, графиков, и изображений будет комплект типов которые моделированные подобными к типам названного космоса System.Drawing рамок NET. С этими типами not only по возможности создать содержание страниц pdf в легкой дороге, но их можно также использовать для того чтобы нарисовать в окне или на принтере. Дополнительно PDFsharp вполне моделирует элементы структуры, котор pdf основан дальше. С ими существуя документы pdf можно доработать, после того как я слиты, или разделение с легкостью. Кодим источника PDFsharp будет открытый источник под лицензией mit (http://en.wikipedia.org/wiki/MIT_License). Поэтому по возможности использовать PDFsharp без проблем в non открытом источнике или коммерчески projects/products.", 

      // Your language may come here
      "Invitation\n" +
      "If you use PDFsharp and haven't found your native language in this document, we will be pleased to get your translation of the text above and include it here.\n" +
      "Mail to PDFsharpSupport@pdfsharp.de"


      // The current implementation of PDFsharp is limited to left-to-right languages.
      // Languages like Arabic cannot yet be created even with Unicode fonts. Also the so called
      // CJK (Chinese, Japanese, Korean) support in PDF can also not be addressed with PDF sharp.
      // However, we plan to support as much as possible languages with PDFsharp. If you are a 
      // programmer and a native speaker of one of these languages and you like to create PDF
      // documents in your language, you can help us to implement it in PDFsharp. You don't have
      // to do the programming, but just help us to verify our implementation.
    };
  }
}
/*
PDFsharp is a .NET library for creating and processing PDF documents 'on the fly'.
The library is completely written in C# and based exclusively on safe, managed code.
PDFsharp offers two powerful abstraction levels to create and process PDF documents.
For drawing text, graphics, and images there is a set of classes which are modeled similar to the classes
of the name space System.Drawing of the .NET framework. With these classes it is not only possible to create
the content of PDF pages in an easy way, but they can also be used to draw in a window or on a printer.
Additionally PDFsharp completely models the structure elements PDF is based on. With them existing PDF documents
can be modified, merged, or split with ease.
The source code of PDFsharp is Open Source under the MIT license (http://en.wikipedia.org/wiki/MIT_License).
Therefore it is possible to use PDFsharp without limitations in non open source or commercial projects/products.
*/
